-- CMD Marathon Soccer v1.1 (090725)
-- by DJ Command 
-- 
-- http://cmdplus.tuzikaze.com/
-- http://www.s-a-r.jp/
-- dj-command@y3.dion.ne.jp

---------------- Initial Values ----------------
Triggers = {}
B = false
REDTEAM = "red"
BLUETEAM = "blue"
STARTTIME = 90
OUTOFGAME = false
THROWIN = false
THROWER = nil
STOPTIME = 0
THROWINTIME = 0
GOALED = false
BALL = nil
------------------------------------------------

function Triggers.init()
	if Game.type ~= "netscript" then
		for P in Players() do
			P.overlays[0].text = "Practice Mode. In order to play this game, please change game mode to NETSCRIPT."
		end
	end
	---------------- Init Values Install ----------------
	for P in Players() do
		P._TXTRELEASE = 0
		P._OLDX = P.x
		P._OLDY = P.y
		P._OLDZ = P.z
		P._OLDP = P.polygon
		
		P._deltafacing = 0
		P._HURUEBOUSHI = 0
		P._STOPROTATE = false
		P._SHOOTACTION = P.weapons["fist"].primary.rounds
		P.compass.lua = true
		P.compass.beacon = true
	end
	
	for M in Monsters() do
		if M.player == nil then -------- Is Ball.
			BALL = M
			BALL._KICKEDPLAYER = nil
			BALL._CATCHED = false
			BALL._MAXZ = 2
			BALL._LANDX = BALL.x
			BALL._LANDY = BALL.y
			BALL._LANDP = BALL.polygon
			BALL._OLDX = BALL.x
			BALL._OLDY = BALL.y
			BALL._OLDZ = 2
			BALL._OLDP = BALL.polygon
			BALL._STARTP = BALL.polygon
		end
	end
	---------------- Set Team to Players ----------------
	BLUECNT = 0
	REDCNT = 0
	LIMITTEAM = math.floor(#Players / 2)
	
	for P in Players() do
		if (REDCNT < LIMITTEAM) and (BLUECNT < LIMITTEAM) then 
			if math.floor(Game.global_random(2)) == 0 then
				P.team = REDTEAM
				REDCNT = REDCNT + 1
			else
				P.team = BLUETEAM
				BLUECNT = BLUECNT + 1
			end
		else
			if (REDCNT == LIMITTEAM) then
				P.team = BLUETEAM
			else
				P.team = REDTEAM
			end
		end 
	end
	---------------- Set Position to Players ----------------
	SDSDSDS = 0
	for P in Players() do
		for OBJ in Scenery() do
			if OBJ._ISUSED == nil then
				if (P.team == REDTEAM and OBJ.y > 0) or (P.team == BLUETEAM and OBJ.y < 0) then
					P:position(OBJ.x,OBJ.y,0,OBJ.polygon)
					P._STARTX = OBJ.x
					P._STARTY = OBJ.y
					P._STARTP = P.polygon
					OBJ._ISUSED = true
					P._SHOOTACTION = P.weapons["fist"].primary.rounds
					P.yaw = 180 + math.deg(math.atan2(P.y, P.x))
					P.external_velocity.i = 0
					P.external_velocity.j = 0
					P.external_velocity.k = 0
					P.external_velocity.x = 0
					P.external_velocity.y = 0
					P.external_velocity.z = 0
					break
				end
			end
		end
	end
	---------------- Set Activate to Ball ----------------
	BALL:position(0,0,2,BALL._STARTP)
	BALL.active = true
end

--∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞--
--∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞--
--∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞--
--∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞--
--∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞--
--∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞∞--


function Triggers.idle()
	if STARTTIME < 0 then
		if OUTOFGAME then -------- "Over the TouchLine."
			for P in Players() do
				STOPPINGGAME(P)
				LOOKATBALL(P)
				JUMPING(P)
				PLAYEREVENT(P)
				if STOPTIME < 0 then
					P._HURUEBOUSHI = 0
					P._STOPROTATE = false
					if P.index == 0 then CHOOSENEARESTPLAYER() end ---- "once exam."
				end
			end
		elseif THROWIN then -------- "Throw in time."
			for P in Players() do
				if P == THROWER then THROWING() end
				SHOOTING(P)
				JUMPING(P)
				REFRESHPOS(P)
				PLAYEREVENT(P)
			end
		else -------- "Normal Playing"
			for P in Players() do
				if GOALED then 
					if STOPTIME == 0 and P.index == 0 then RESETFIELD() end ---- "once exam."
				else
					SHOOTING(P)
					if P.index == 0 then SOCCEREVENT() end ---- "once exam."
					JUMPING(P)
					REFRESHPOS(P)
					PLAYEREVENT(P)
				end
			end
		end
	else
		FIRSTCOUNT()
	end
	BALLBOUNCE()
	STOPTIME = STOPTIME - 1
end

function BALLBOUNCE()
	if BALL.z <= 0 then
		if BALL._MAXZ > 0.1 then
			BALL._MAXZ = BALL._MAXZ/2
			BALL:accelerate(BALL.yaw+180,0,BALL._MAXZ/15)
			BALL:play_sound("ball bounce")
		end
	end
	BALL._MAXZ = math.max(BALL._MAXZ,BALL.z)
	BALL._OLDX = BALL.x
	BALL._OLDY = BALL.y
	BALL._OLDZ = BALL.z
end

function RESETFIELD()
	STARTTIME = 90
	GOALED = false
	for O in Scenery() do
		O._ISUSED = nil
	end
	
	for P in Players() do
		P:fade_screen("white")
		P:play_sound("teleport in")
		for OBJ in Scenery() do
			if OBJ._ISUSED == nil then
				if (P.team == REDTEAM and OBJ.y > 0) or (P.team == BLUETEAM and OBJ.y < 0) then
					P:position(OBJ.x,OBJ.y,0,OBJ.polygon)
					P._STARTX = OBJ.x
					P._STARTY = OBJ.y
					P._STARTP = P.polygon
					OBJ._ISUSED = true
					P._SHOOTACTION = P.weapons["fist"].primary.rounds
					P.yaw = 180 + math.deg(math.atan2(P.y, P.x))
					P.external_velocity.i = 0
					P.external_velocity.j = 0
					P.external_velocity.k = 0
					P.external_velocity.x = 0
					P.external_velocity.y = 0
					P.external_velocity.z = 0
					P.compass.x = 0
					P.compass.y = 0
					P.oxygen = 10800
				end
			end
		end
	end
	---------------- Set Activate to Ball ----------------
	BALL:position(0.000,0.000,2,BALL._STARTP)
	BALL.active = true
end


function SOCCEREVENT()
	if BALL.polygon.type == "item impassable" and BALL.z <= 0.000 then -------- "Over the TouchLine."
		for P in Players() do
			P:play_sound("oxygen warning",0.5)
			P.overlays[0].text = "Ball exceeded the touchline. Player nearest to a ball is thrower."
			P.overlays[0].color = 0
			P._TXTRELEASE = 90
			P._deltafacing = P.yaw
		end
		BALL._LANDX = BALL.x
		BALL._LANDY = BALL.y
		BALL._LANDP = BALL.polygon
		OUTOFGAME = true
		STOPTIME = 30
	end
	
	K = (BALL._OLDX - BALL.x)^2 + (BALL._OLDY - BALL.y)^2 + (BALL._OLDZ - BALL.z)^2
	if (BALL.polygon.type == "hill") or (BALL.polygon.type == "monster impassable" and K == 0)  then -------- "GOAL !!!!"
		GOALED = true
		if ((BALL._KICKEDPLAYER.team == REDTEAM and BALL.y < 0) or (BALL._KICKEDPLAYER.team == BLUETEAM and BALL.y > 0)) then
			for P in Players() do
				if BALL._KICKEDPLAYER == P then
					P:play_sound("you are it",1)
					P.overlays[0].text = "GOAL! You scored a goal. You're hero!"
					P:accelerate(0,0,0.125)
					if #Players ~= 1 then P.points = P.points + 1 end
				elseif P.team == BALL._KICKEDPLAYER.team then
					P:play_sound("you are it",1)
					P.overlays[0].text = "GOAL! ".. BALL._KICKEDPLAYER.name .." of your team scored a goal!"
					P:accelerate(0,0,0.075)
				else
					P:play_sound("suffocation",1)
					P.overlays[0].text = "Enemy team was reached!!!"
				end
				P.overlays[0].color = 0
				P._TXTRELEASE = 90
				P._deltafacing = P.yaw
			end
		else -------- "OWN GOAL !!!!"
			for P in Players() do
				if BALL._KICKEDPLAYER == P then
					P:play_sound("suffocation",1)
					P.overlays[0].text = "OWN GOAL!! What are you doing!?!?!?"
				elseif P.team == BALL._KICKEDPLAYER.team then
					P:play_sound("you are it",1)
					P.overlays[0].text = "OWN GOAL!! ".. BALL._KICKEDPLAYER.name .." made the mistake!"
				else
					P:play_sound("you are it",1)
					P.overlays[0].text = "Enemy team was OWN GOAL!! Somebody of yours gets 1 points."
					P:accelerate(0,0,0.075)
					if #Players ~= 1 and B == false then
						B = true
						P.points = P.points + 1
					end
				end
				P.overlays[0].color = 0
				P._TXTRELEASE = 90
				P._deltafacing = P.yaw
			end
		end
		B = false
		STOPTIME = 90
	end
end


function SHOOTING(P)
	BALL.life = 10000
	DIST = (P.x - BALL.x)^2 + (P.y - BALL.y)^2 + (P.z - BALL.z)^2
	DRIBLAREA = (0.204 + BALL.type.radius + 0.250)^2
	SHOOTAREA = (0.204 + BALL.type.radius + 1.000)^2
	
	if BALL._CATCHED then
		if THROWIN then
			N = THROWER
		else
			N = BALL._KICKEDPLAYER
		end
		K = math.rad(N.yaw) -------- "cf. P.yaw * PI / 180"
		X = math.cos(K)*0.500
		Y =	math.sin(K)*0.500
		Z =	math.sin(math.rad(N.pitch))*0.500
		BALL:position(N.x+X,N.y+Y,N.z+0.700+Z,N.polygon)
	end

	if DIST < DRIBLAREA and BALL._CATCHED == false then -- "Dribble."
		if P.internal_velocity.forward >= 0 then
			SPD = math.sqrt(P.internal_velocity.perpendicular^2 + P.internal_velocity.forward^2)
		else
			SPD = 0
		end
			
		if (P.polygon.type == "zone border") then
			if (P.team == REDTEAM and P.y > 0) or (P.team == BLUETEAM and P.y < 0) then
				BALL._CATCHED = true
				BALL._KICKEDPLAYER = P
			end
		end
		
		if (SPD < 0.050) then -------- "catch"
			BALL:accelerate(BALL.yaw, 0, -1)
			
		else -------- "Dribble."
			--X = (P.x - BALL.x)
			--Y =	(P.y - BALL.y)
			--DIST = math.sqrt(((P.x - BALL.x)^2 + (P.y - BALL.y)^2))
			--X = (X/DIST)*0.200
			--Y = (Y/DIST)*0.200
			--I = Projectiles.new(BALL.x + X, BALL.y + Y, BALL.z + BALL.type.height / 2, BALL.polygon, "fist").index
			
			--K = 180 + math.deg(math.atan2(P._OLDY - P.y, P._OLDX - P.x))
			
			
			
			
			K = math.rad(P.yaw) -------- cf. P.yaw * PI / 180
			X = math.cos(K)*0.200
			Y =	math.sin(K)*0.200
			I = Projectiles.new(BALL.x - X, BALL.y - Y, BALL.z + BALL.type.height / 2, BALL.polygon, "fist").index
			Projectiles[I].damage_scale = 0.500
			Projectiles[I].owner = P
			BALL:play_sound("flickta melee hit",0)
			BALL._KICKEDPLAYER = P
		end
	end

	if DIST < SHOOTAREA  then
		I = P._SHOOTACTION - P.weapons["fist"].primary.rounds
		if I > 0 then
			SPD = math.sqrt(P.internal_velocity.perpendicular^2 + P.internal_velocity.forward^2)
			if I == 1 then -------- "Shoot."
				PW = 1.000 + (SPD/0.140)*0.500
			elseif I == 4 then -------- "Long Shoot."
				PW = 1.500 + (SPD/0.140)*1.500
			end
			K = math.rad(P.yaw) -------- cf. P.yaw * PI / 180
			X = math.cos(K)*0.100
			Y =	math.sin(K)*0.100
			if BALL._CATCHED then
				BALL:accelerate(P.yaw,0,001)
				Z =	math.sin(math.rad(P.pitch*1.5))*0.1
			else
				Z =	math.sin(math.rad(P.pitch*1.5))*0.1
			end
			
			I = Projectiles.new(BALL.x - X, BALL.y - Y, BALL.z + BALL.type.height / 2 - Z, BALL.polygon, "fist").index
			Projectiles[I].damage_scale = PW
			Projectiles[I].owner = P
			BALL:play_sound("fist hitting",0)
			BALL._KICKEDPLAYER = P
			if THROWER ~= nil then
				P.overlays[0].text = "Return to the field and resume a game!"
				P.overlays[0].color = 0
				P._TXTRELEASE = 90
				THROWIN = false
				THROWER = nil
			end
			BALL._CATCHED = false
		end
	end
	
end


function PLAYEREVENT(P)

	if THROWIN == true and P ~= THROWER then
		P.action_flags.left_trigger = false
		P.action_flags.right_trigger = false
	end
	
	if BALL._KICKEDPLAYER == P and P.polygon.type ~= "zone border" and THROWIN == false then -------- "can't catch except G.K. area."
		BALL._CATCHED = false
	end
	
	if P.polygon.type == "zone border" then
		if (P.team == REDTEAM and P.y < 0) or (P.team == BLUETEAM and P.y > 0) then
			X = (P.x - P.polygon.x)
			Y =	(P.y - P.polygon.y)
			DIST = math.sqrt(((P.x - P.polygon.x)^2 + (P.y - P.polygon.y)^2))
			X = (X/DIST)*0.250
			Y = (Y/DIST)*0.250
			P:position(P.x+X,P.y+Y,P.z,P.polygon)
			P.monster:play_sound("absorbed",1)
		end 
	end
	
	if P._TXTRELEASE == 0 then
		P.overlays[0].text = ""
	end
	if P.team == REDTEAM then
		P.overlays[5].text = "                              Your Team : RED"
		P.overlays[5].color = "red"
	else
		P.overlays[5].text = "                              Your Team : BLUE"
		P.overlays[5].color = "blue"
	end
	P.life = 450
	P._SHOOTACTION = P.weapons["fist"].primary.rounds
	P._TXTRELEASE = P._TXTRELEASE -1
	P.weapons["fist"]:select()
	P.compass.x = BALL.x
	P.compass.y = BALL.y
	P.oxygen = math.min(10800,P.oxygen+5)
end


function CHOOSENEARESTPLAYER()
	OUTOFGAME = false
	THROWIN = true
	THROWINTIME = 150
	SHORTEST = 1000
	for P in Players() do
		DIST = math.sqrt((P.x - BALL.x)^2 + (P.y - BALL.y)^2)
		if (P.team ~= BALL._KICKEDPLAYER.team and DIST < SHORTEST) then
			SHORTEST = DIST
			THROWER = P
		end
	end
	
	BALL._CATCHED = true
	THROWER:fade_screen("white")
	THROWER:play_sound("teleport in")
	THROWER:position(BALL._LANDX ,BALL._LANDY ,0,BALL._LANDP)
	THROWER.yaw = 180 + math.deg(math.atan2(BALL._LANDY, BALL._LANDX))
end


function THROWING()
	if THROWINTIME % 30 == 0 then
		THROWER:play_sound("computer login",2)
	end
	
	if THROWINTIME == 0 then ----"Delay act!!! no good!!!"
		BALL:position(BALL.x,BALL.y,0.000,BALL.polygon)
		THROWIN = false
		BALL._CATCHED = false
		BALL._KICKEDPLAYER = THROWER
	end
	THROWER.overlays[0].text = "Throw a ball within ".. math.floor(THROWINTIME/30) .." seconds!!!"
	THROWER.overlays[0].color = 5
	THROWER:position(BALL._LANDX ,BALL._LANDY ,THROWER.z,BALL._LANDP)
	THROWINTIME = THROWINTIME - 1
end


function STOPPINGGAME(P)
	P:position(P._OLDX,P._OLDY,P.z,P._OLDP)
end


function LOOKATBALL(P)
	K = math.rad(P.yaw)
	ax = math.sin(K)
	ay = -math.cos(K)
	bx = BALL.x - P.x
	by = BALL.y - P.y
	if P._STOPROTATE == false then
		if (ax*bx + ay*by) > 0 then
			P._deltafacing = P._deltafacing - 8
			if P._HURUEBOUSHI == 2 then P._STOPROTATE = true end
			P._HURUEBOUSHI = 1
		else
			P._deltafacing = P._deltafacing + 8
			if P._HURUEBOUSHI == 1 then P._STOPROTATE = true end
			P._HURUEBOUSHI = 2
		end	
	end
	P.yaw = P._deltafacing
end


function REFRESHPOS(P)
	P._OLDX = P.x
	P._OLDY = P.y
	P._OLDZ = P.z
	P._OLDP = P.polygon
end


function JUMPING(P)
	if P.external_velocity.z == 0 and P.action_flags.microphone_button then
		P:accelerate(0,0,0.075)
		P.monster:play_sound("flickta projectile lava flyby",1)
	end
	
	if P.oxygen > 1000 and P.action_flags.action_trigger then
		P.oxygen = P.oxygen - 1500
		P:accelerate(P.yaw,0.1,0)
		P.monster:play_sound("rocket flyby",1)
	end
end


function FIRSTCOUNT()
	for P in Players() do
		if (STARTTIME == 0) then
			P.overlays[0].text = "<< GAME START >>"
			P.overlays[0].color = 0
			P._TXTRELEASE = 90
			P:play_sound("alarm",0)
			
		else
			P.weapons["fist"]:select()
			if STARTTIME % 30 == 0 then
				P.overlays[0].text = "Are you ready!? ... "..math.floor(STARTTIME/30)
				P.overlays[0].color = 0
				P:play_sound("computer login",2)
			end
		end			
	end	
	for P in Players() do
		P:position(P._STARTX,P._STARTY,P.z,P._STARTP)
	end
	BALL:position(0.000,0.000,BALL.z,BALL._STARTP)
	STARTTIME = STARTTIME - 1
end